#include "downloadsmodel.h"
#include <QDebug>


DownloadsModel::DownloadsModel(QObject* parent)
    :QAbstractTableModel(parent)
{

}


int DownloadsModel::rowCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent)
    return DownLoadList.count();
}

int DownloadsModel::columnCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent)
    return 2;
}

QVariant DownloadsModel::data(const QModelIndex &index, int role) const
{
    if(role== Qt::DisplayRole)
    {
        if( index.column() == 0 )
        {
            return DownLoadList.at(index.row())->url();
        }
        else if ( index.column() == 1)
        {

            if( DownLoadList.at(index.row())->wasAborted() )
            {
                return -1;
            }

           if(DownLoadList.at(index.row())->total() > 0)
            return ( DownLoadList.at(index.row())->progress() * 100  / DownLoadList.at(index.row())->total());
           else return 0;
        }
    }

    return QVariant();
}

bool DownloadsModel::setData(const QModelIndex &index, const QVariant &value, int role)
{

    Downloads* currentDownload = new Downloads(value.toUrl(), this);

    beginInsertRows(QModelIndex(),rowCount()+1,rowCount()+1);
    DownLoadList.append(currentDownload);
    emit endInsertRows();

    connect(DownLoadList.last(), SIGNAL(downloadProgress(qint64,qint64)), this, SLOT(handleProgress(qint64,qint64)));

    QModelIndex topLeft = createIndex(0,0);


    //emit a signal to make the view reread identified data
        emit dataChanged(topLeft, topLeft);
    return false;
}

QVariant DownloadsModel::headerData(int section, Qt::Orientation orientation, int role) const
{
    if(orientation == Qt::Horizontal
            && role == Qt::DisplayRole)
    {
        switch(section)
        {
            case 0: return QString("URL");break;
            case 1: return QString("Progress");break;
        }
    }
    return QVariant();
}

void DownloadsModel::handleProgress(qint64 current, qint64 total)
{

    QObject* object = sender();
    Downloads* download= qobject_cast<Downloads*>(object);

    if(download)
    {
        int row = DownLoadList.indexOf(download);
        QModelIndex topLeft = createIndex(row,1);
        emit dataChanged(topLeft , topLeft);
    }


}

void DownloadsModel::cancelDownload(QModelIndex index)
{

        DownLoadList.at(index.row())->abortDownload();
}