#ifndef DOWNLOADSMODEL_H
#define DOWNLOADSMODEL_H

#include <QAbstractTableModel>
#include "downloads.h"
#include <QList>


class DownloadsModel : public QAbstractTableModel
{
    Q_OBJECT
public:
    DownloadsModel(QObject *parent = 0);

    // QAbstractItemModel interface
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    bool setData(const QModelIndex &index, const QVariant &value, int role);
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;

    void cancelDownload(QModelIndex);

protected slots:
    void handleProgress(qint64,qint64);


private:
    QList<Downloads*> DownLoadList;
};

#endif // DOWNLOADSMODEL_H