#include "progressbardelegate.h"
#include <QStyle>
#include <QDebug>
#include <QPainter>
#include <QProgressBar>
#include <QStyleOptionProgressBar>
#include <QApplication>

ProgressBarDelegate::ProgressBarDelegate(QObject *parent):QStyledItemDelegate(parent)
{

}

void ProgressBarDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{

    if (index.column() == 1)
    {
        int progressPercentage = index.model()->data(index, Qt::DisplayRole).toInt();

        if( progressPercentage >= 0 )
        {

            QStyleOptionProgressBar progressBarOption;
            progressBarOption.rect = QRect(option.rect.x()+5, option.rect.y() + 5 , option.rect.width()-10, option.rect.height()-10);
            progressBarOption.minimum = 0;
            progressBarOption.maximum = 100;
            progressBarOption.progress = progressPercentage;

            progressBarOption.text= QString::number( progressPercentage ) + "%";
            progressBarOption.textAlignment = Qt::AlignCenter;
            progressBarOption.textVisible = true;


            if (option.state & QStyle::State_Selected)
                painter->fillRect(option.rect, option.palette.alternateBase());

            QApplication::style()->drawControl( QStyle::CE_ProgressBar,
                                                &progressBarOption,
                                                painter);
        }
        else
        {

            QIcon forbiddenIcon = QApplication::style()->standardIcon(QStyle::SP_MessageBoxWarning);
            QRect forbiddenRect = option.rect;
            forbiddenRect.setWidth(forbiddenRect.height());
            forbiddenRect.setX(option.rect.x()+ option.rect.width()/2- forbiddenRect.width()/2);
            painter->drawPixmap(forbiddenRect, forbiddenIcon.pixmap(option.rect.size()));

        }
    }
    else
    {
        QStyledItemDelegate::paint(painter, option, index);
    }

}
