#include "widget.h"
#include "ui_widget.h"
#include "downloadsmodel.h"
#include "progressbardelegate.h"
#include <QInputDialog>
#include <QMenu>
#include <QContextMenuEvent>
#include <QUrl>
#include <QDebug>

Widget::Widget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Widget)
{
    ui->setupUi(this);

    cancelDownloadAction = new QAction("Cancel Download", this);

    downloadAction = new QAction( "Download",  this);

    DownloadsModel* downloadModel= new DownloadsModel(this);

    ProgressBarDelegate* delegate = new ProgressBarDelegate(this);

    ui->DownloadTable->setModel(downloadModel);
    ui->DownloadTable->setItemDelegateForColumn( 1, delegate);

    connect(downloadAction,SIGNAL(triggered(bool)), this, SLOT(showDownloadDialog()));

    connect(cancelDownloadAction,SIGNAL(triggered(bool)), this, SLOT(cancelDownload()));


    ui->DownloadTable->setContextMenuPolicy(Qt::CustomContextMenu);
    connect(ui->DownloadTable, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(customMenuRequested(QPoint)));
}

Widget::~Widget()
{
    delete ui;
}

void Widget::showDownloadDialog()
{

    QString URL = QInputDialog::getText(this,"Download URL", "Enter URL to download");
    //validate the URL
    if( !URL.isEmpty() )
    {
        ui->DownloadTable->model()->setData(ui->DownloadTable->model()->index(ui->DownloadTable->model()->rowCount(), 0), QUrl(URL));
    }

}


void Widget::cancelDownload()
{



      DownloadsModel* downloadModel = qobject_cast<DownloadsModel*>( ui->DownloadTable->model());
      if( downloadModel )
      {
        downloadModel->cancelDownload(ui->DownloadTable->currentIndex());
      }




}

void Widget::customMenuRequested(QPoint pos)
{
    QModelIndex index = ui->DownloadTable->indexAt(pos);
    QMenu menu(this);

    if(index.row() == -1)
    {
        menu.addAction(downloadAction);

    }
    else
        menu.addAction(cancelDownloadAction);

    menu.exec(ui->DownloadTable->viewport()->mapToGlobal(pos));
}

void Widget::contextMenuEvent(QContextMenuEvent *event)
{

}
