#include "mainwindow.h"
#include <QVBoxLayout>
#include <QHBoxLayout>
MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent),
      debugOutput(new QLCDNumber(this))
{
    initDisplay();
    initConnections();
}

void MainWindow::initDisplay()
{
    auto mainLayout = new QVBoxLayout();
    mainLayout->addWidget(debugOutput);

    auto mainWidget = new QWidget(this);
    mainWidget->setLayout(mainLayout);

    setCentralWidget(mainWidget);
}

void MainWindow::initConnections()
{
    connect(slider, &QSlider::valueChanged, debugOutput, QOverload<int>::of(&QLCDNumber::display));
}

