#include "mainwindow.h"
#include <QMouseEvent>

bool MainWindow::eventFilter(QObject *object, QEvent *event)
{
    if (object == button && event->type() == QEvent::MouseButtonPress) {
        QMouseEvent * mouseEvent = static_cast<QMouseEvent *>(event);
        if(mouseEvent->button() == Qt::LeftButton)
            move(pos().x() - 10, pos().y());
        if(mouseEvent->button() == Qt::RightButton)
            move(pos().x() + 10, pos().y());
        return true;
    }
    return false;
}

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent),
      button(new QPushButton(QStringLiteral("< >"), this))
{
    button->installEventFilter(this);
    setCentralWidget(button);
}
