#include "mainwindow.h"
#include <QVBoxLayout>
#include <QHBoxLayout>
MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent),
      slider(new QSlider(Qt::Horizontal, this)),
      label(new QLabel(QString::number(slider->value()), this)),
      debugOutput(new QLCDNumber(this))
{
    initDisplay();
    initConnections();
}

void MainWindow::initDisplay()
{
    auto sliderLayout = new QHBoxLayout();
    sliderLayout->addWidget(slider);
    sliderLayout->addWidget(label);

    auto mainLayout = new QVBoxLayout();
    mainLayout->addLayout(sliderLayout);
    mainLayout->addWidget(debugOutput);

    auto mainWidget = new QWidget(this);
    mainWidget->setLayout(mainLayout);

    setCentralWidget(mainWidget);
}

void MainWindow::initConnections()
{
    connect(slider, &QSlider::valueChanged, label, QOverload<int>::of(&QLabel::setNum));
    connect(slider, &QSlider::valueChanged, debugOutput, QOverload<int>::of(&QLCDNumber::display));
}
