import QtQuick 2.6
import QtQuick.Window 2.2

Window {

    visible: true
    width: 480
    height: 800

    Item{
        anchors.fill: parent
        id: main

        Rectangle{
            anchors.top: parent.top
            width: theText.width
            height: theText.height
            color:"blue"

            Text{
                id: theText
                color: "white"
                anchors.centerIn: parent
                text: qsTr("Notification")
            }

            MouseArea{
                anchors.fill: parent
                onClicked: {
                    shipListModel.refresh();
                }
            }


        }

        Text{
            anchors.centerIn: parent
            text: qsTr("Background....")
            color: "blue"
            rotation: -45
            font.pixelSize: 26
            enabled: listView.count === 0

            MouseArea{
                anchors.fill: parent
                onClicked: {
                    console.log("Ouch!")
                }
            }
        }


        NumberAnimation {
            id: greatAnimation

            target: listView
            properties: "height"
            duration: 1000

        }


        ListView {
            id: listView
            width: main.width;
            height: 100 * listView.count
            anchors.bottom : main.bottom
            model: shipListModel
            interactive: false


            PropertyAnimation on height {
                    duration: 400;
                    from: 0
                    to: 100 * listView.count
                    easing.type: Easing.OutBounce
                }


            delegate: Rectangle {
                width: main.width; height: 100
                transformOrigin: Item.Top
                border.width: 1
                color: "lightsteelblue"
                Text {
                    anchors.centerIn: parent
                    text: model.id + " " +  model.name
                }

                MouseArea{
                    anchors.fill: parent
                    onClicked: {
                        console.log("Ouch!")
                    }

                }
            }

            add: Transition {
                NumberAnimation { property: "scale";
                    from: 0; to: 1.0;
                    duration: 400;
                    easing.type: Easing.OutBounce
                }
            }


            displaced: Transition {
                NumberAnimation { properties: "x,y"; duration: 400; easing.type: Easing.OutBounce }
            }

            removeDisplaced: Transition {
                NumberAnimation { properties: "x,y"; duration: 400; easing.type: Easing.OutBounce }
            }

            remove: Transition{
                NumberAnimation { property: "scale"; from: 1.0; to: 0; duration: 400; easing.type: Easing.OutBounce }
            }

        }
    }
}

