#include "shiplist.h"
#include <QTimer>
#include <QSqlDatabase>
#include <QSqlResult>
#include <QDebug>

void ShipListModel::refresh()
{
    QSqlQuery m_query = QSqlQuery("SELECT id, name FROM people", m_db);
    setQuery(m_query);

   beginResetModel();
   endResetModel();

}

void ShipListModel::initDatabase()
{
    //This is where you put the path of the db file
    m_db.setDatabaseName("../ShipList/example.db");

    if (m_db.open()) {

     }
    else {
        qDebug() << ("Unable to establish a database connection.\n"
                     "This example needs SQLite support. Please read "
                     "the Qt SQL driver documentation for information how "
                     "to build it.\n\n"
                     "Click Cancel to exit.");
    }
}

ShipListModel::ShipListModel(QObject *parent)
    : QSqlQueryModel(parent), m_db(QSqlDatabase::addDatabase("QSQLITE"))
{

    //DataBase name goes here
    initDatabase();
    refresh();
}

QVariant ShipListModel::data ( const QModelIndex & index, int role ) const
{

    if(index.row() >= rowCount())
    {
        return QString("");
    }
    if(role < Qt::UserRole)
    {
        return QSqlQueryModel::data(index, role);
    }
    else
    {
        return QSqlQueryModel::data(this->index(index.row(), role - Qt::UserRole - 1), Qt::DisplayRole);
    }
}


QHash<int, QByteArray> ShipListModel::roleNames() const noexcept
{
    QHash<int, QByteArray> roleNames;
    for (int i = 0; i < columnCount(); i++)
    {        
        roleNames[Qt::UserRole + i + 1] = QVariant(headerData(i, Qt::Horizontal).toString()).toByteArray();
    }

    return roleNames;
}
