#ifdef LINK_MODULE
#include "mycomponentslibrary.h"
#endif

#include <QDir>
#include <QGuiApplication>
#include <QQmlApplicationEngine>

#include <QDirIterator>
#include <QTimer>

void printQtResourceTree()
{
    qDebug() << "Qt Resource Filesystem:";
    qDebug() << "(root)";

    QDirIterator it(":", QDirIterator::Subdirectories);
    QStringList allPaths;

    // Collect all paths first
    while (it.hasNext()) {
        QString path = it.next();
        allPaths << path;
    }

    // Sort paths for better organization
    allPaths.sort();

    // Print each path with appropriate formatting
    for (const QString &path : std::as_const(allPaths)) {
        QDir dir(path);
        if (dir.exists()) {
            // It's a directory
            int depth = path.count('/');
            QString indent = QString("  ").repeated(depth);
            QString dirName = path.split('/').last();
            qDebug() << indent << dirName << "(" + path + ")";
        } else {
            // It's a file
            int depth = path.count('/');
            QString indent = QString("  ").repeated(depth);
            QString fileName = path.split('/').last();
            qDebug() << indent << fileName << "(" + path + ")";
        }
    }
}

int main(int argc, char *argv[])
{
    QGuiApplication app(argc, argv);
    QQmlApplicationEngine engine;

#ifdef LINK_MODULE
    MyComponentsLibrary::init();
    engine.addImportPath(":/qmlmodules");
    QTimer::singleShot(500, &app, []() { printQtResourceTree(); });
#else
    engine.addImportPath(QCoreApplication::applicationDirPath() + "/../qmlmodules");
#endif

    const QUrl url(QStringLiteral("qrc:/main.qml"));
    QObject::connect(
        &engine,
        &QQmlApplicationEngine::objectCreated,
        &app,
        [url](QObject *obj, const QUrl &objUrl) {
            if (!obj && url == objUrl)
                QCoreApplication::exit(-1);
        },
        Qt::QueuedConnection);
    engine.load(url);

    return app.exec();
}
