import QtQuick 2.12
import QtQuick.Window 2.12
import QtQuick.Controls 2.12
import QtQuick.Layouts 1.12
import MyComponents 1.0

ApplicationWindow {
    id: window
    width: 640
    height: 480
    visible: true
    title: MySingleton.applicationName

    ColumnLayout {
        anchors.fill: parent
        anchors.margins: 20
        spacing: 20

        // Title
        Text {
            Layout.fillWidth: true
            text: "Qt5 QML Module Demo"
            font.pixelSize: 24
            font.bold: true
            horizontalAlignment: Text.AlignHCenter
        }

        // Custom Graphics Item
        CustomGraphicsItem {
            id: customItem
            Layout.alignment: Qt.AlignHCenter
            color: colorSlider.value < 0.33 ? "red" :
                   colorSlider.value < 0.66 ? "green" : "blue"
            text: "Counter: " + MySingleton.counter
        }

        // Color control
        RowLayout {
            Layout.fillWidth: true

            Text {
                text: "Color:"
                font.pixelSize: 16
            }

            Slider {
                id: colorSlider
                Layout.fillWidth: true
                from: 0
                to: 1
                value: 0.5
            }
        }

        // Singleton info
        GroupBox {
            Layout.fillWidth: true
            title: "Singleton Information"
            
            ColumnLayout {
                anchors.fill: parent
                
                Text {
                    text: "Application: " + MySingleton.applicationName
                    font.pixelSize: 14
                }
                
                Text {
                    text: "Counter: " + MySingleton.counter
                    font.pixelSize: 14
                }
            }
        }

        // Controls
        RowLayout {
            Layout.fillWidth: true
            
            Button {
                text: "Reset Counter"
                onClicked: MySingleton.resetCounter()
            }
        }
    }
}
