#include "mycomponentslibrary.h"
#include "mysingleton.h"

#include <QQmlEngine>

void MyComponentsLibrary::init()
{
#ifdef LINK_MODULE
    Q_INIT_RESOURCE(mycomponents);

    // Register the singleton
    qmlRegisterSingletonType<MySingleton>("MyComponents",
                                          1,
                                          0,
                                          "MySingleton",
                                          [](QQmlEngine *engine,
                                             QJSEngine *scriptEngine) -> QObject * {
                                              Q_UNUSED(engine)
                                              Q_UNUSED(scriptEngine)
                                              return new MySingleton();
                                          });
#endif
}
