#ifndef MYSINGLETON_H
#define MYSINGLETON_H

#include "mycomponentsdecl.h"

#include <QObject>
#include <QTimer>

class MYCOMPONENTS_EXPORT MySingleton : public QObject
{
    Q_OBJECT
    Q_PROPERTY(int counter READ counter NOTIFY counterChanged)
    Q_PROPERTY(QString applicationName READ applicationName CONSTANT)

public:
    explicit MySingleton(QObject *parent = nullptr);

    int counter() const;
    QString applicationName() const;

    Q_INVOKABLE void resetCounter();
    Q_INVOKABLE QString formatMessage(const QString &message);

signals:
    void counterChanged();

private slots:
    void incrementCounter();

private:
    int m_counter;
    QTimer *m_timer;
};

#endif // MYSINGLETON_H
