import QtQuick

Rectangle {
    id: root
    property alias text: textLabel.text
    
    width: 200
    height: 100
    radius: 10
    border.width: 2
    border.color: Qt.darker(color, 2.0)
    
    gradient: Gradient {
        GradientStop { position: 0.0; color: Qt.lighter(root.color, 1.5) }
        GradientStop { position: 1.0; color: Qt.darker(root.color, 1.5) }
    }
    
    Text {
        id: textLabel
        anchors.centerIn: parent
        text: "Custom Item"
        color: "white"
        font.pixelSize: 12
        font.bold: true
    }
}
