#include "mysingleton.h"

MySingleton::MySingleton(QObject *parent)
    : QObject(parent)
    , m_counter(0)
    , m_timer(new QTimer(this))
{
    connect(m_timer, &QTimer::timeout, this, &MySingleton::incrementCounter);
    m_timer->start(1000); // Increment every second
}

int MySingleton::counter() const
{
    return m_counter;
}

QString MySingleton::applicationName() const
{
    return "My Qt6 Application";
}

void MySingleton::resetCounter()
{
    m_counter = 0;
    emit counterChanged();
}

QString MySingleton::formatMessage(const QString &message)
{
    return QString("[%1] %2").arg(m_counter).arg(message);
}

void MySingleton::incrementCounter()
{
    ++m_counter;
    emit counterChanged();
}
