#ifndef DATAMODEL_H
#define DATAMODEL_H

#include <QDateTime>
#include <QObject>

class DataModel : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QDateTime time READ time NOTIFY timeChanged) // Property is read only from QML
public:
    DataModel();

    QDateTime time() const;
    void setTime(const QDateTime& time);

signals:
    void timeChanged();

private:
    QDateTime m_time;
};

#endif // DATAMODEL_H
