#include "DataProviderAdapter.h"

#include <QDebug>
#include <QThread>

DataProviderAdapter::DataProviderAdapter(DataProvider& provider)
    : m_provider(provider)
{
    qRegisterMetaType<CommData>("CommData");

    m_provider.RegisterDataCallback([this](const CommData& data)
    {
        auto qtTime = QDateTime::fromSecsSinceEpoch(data.time);
        qDebug() << "DataProviderAdaptereEmitting time from thread context" << QThread::currentThreadId();
        emit timeChanged(qtTime);
    });
}
