#include <QGuiApplication>
#include <QQmlApplicationEngine>
#include <QQmlContext>

#include <QDebug>
#include <QThread>

#include <DataProvider.h>

#include "DataModel.h"
#include "DataProviderAdapter.h"

int main(int argc, char *argv[])
{
    QCoreApplication::setAttribute(Qt::AA_EnableHighDpiScaling);

    QGuiApplication app(argc, argv);

    qDebug() << "Main thread context" << QThread::currentThreadId();

    DataProvider provider; // 3rd party API with hidden thread.
    DataProviderAdapter dataProviderAdapter(provider); // Qt-ify's DataProvider API.
    DataModel model;

    // Connect signals and slots as you normally would.
    // QObject::connect defaults to Qt::AutoConnection enabling
    // cross thread signals and slots. The data model functions
    // are only called from the main thread.
    QObject::connect(&dataProviderAdapter, &DataProviderAdapter::timeChanged,
                     &model, &DataModel::setTime);

    provider.StartCommunications();

    QQmlApplicationEngine engine;
    const QUrl url(QStringLiteral("qrc:/main.qml"));
    QObject::connect(&engine, &QQmlApplicationEngine::objectCreated,
                     &app, [url](QObject *obj, const QUrl &objUrl) {
        if (!obj && url == objUrl)
            QCoreApplication::exit(-1);
    }, Qt::QueuedConnection);

    engine.rootContext()->setContextProperty("dataModel", &model);
    engine.load(url);

    return app.exec();
}
