#include "DataProvider.h"

#include <algorithm>
#include <chrono>
#include <iterator>

DataProvider::DataProvider()
    : m_stopCommunications(false)
{
}

DataProvider::~DataProvider()
{
    StopCommunications();
}

void DataProvider::RegisterDataCallback(std::function<void(const CommData& data)> cb)
{
    // Lists of std::function
    m_dataCallbacks.push_back(cb);
}

void DataProvider::StartCommunications()
{
    m_stopCommunications = false;

    m_commThread = std::thread([this](){
        while(!m_stopCommunications) {
            time_t currentTime;
            time(&currentTime);

            CommData data({std::string("Hello"),
                           currentTime});

            for (const auto& cb : m_dataCallbacks) {
                cb(data);
            }

            std::this_thread::sleep_for(std::chrono::milliseconds(1000));
        }
    });
}

void DataProvider::StopCommunications()
{
   m_stopCommunications = true;
   m_commThread.join();
}
