#ifndef COMMLIB_H
#define COMMLIB_H

#include "CommunicationsLibDecl.h"
#include "CommData.h"

#include <atomic>
#include <time.h>
#include <functional>
#include <thread>
#include <vector>

class COMMLIB_EXPORT DataProvider
{
public:
    DataProvider();
    ~DataProvider();

    void RegisterDataCallback(std::function<void(const CommData& data)> cb);

    void StartCommunications();
    void StopCommunications();

private:
    std::thread m_commThread;
    std::atomic<bool> m_stopCommunications;
    std::vector<std::function<void(const CommData& data)>> m_dataCallbacks;
};

#endif // COMMLIB_H
