#include "BlockingBusThread.h"

#include <QDateTime>
#include <QDebug>

#include "DataProviderInterface.h"

BlockingBusThread::BlockingBusThread(DataProviderInterface& dataProvider)
    : m_dataProvider(dataProvider)
{
}

void BlockingBusThread::run()
{
    // Let's pretend we have an API that allows only for
    // read() that blocks until data arrives and tryRead()
    // that just returns when on data is available. There is
    // no option for interrupt driven option.

    // For this example we will use a while loop as a stand in for the
    // read calls

    while(!isInterruptionRequested()) {
        // Get the data from the bus
        time_t currentTime;
        time(&currentTime);

        // Convert the data to Qt types or
        // structure more consumable by your application code
        auto qtTime = QDateTime::fromSecsSinceEpoch(currentTime);

        // Use the data provider as a signal proxy
        // Notice we are emitting another object's signals
        // The Qt signals keyword is a #define to public.
        emit m_dataProvider.timeChanged(qtTime);

        qDebug() << Q_FUNC_INFO << "thread context" << currentThreadId();
        msleep(1000);
    }
}
