#include <QGuiApplication>
#include <QQmlApplicationEngine>
#include <QQmlContext>

#include <QDebug>
#include <QThread>

#include "DataModel.h"
#include "DataProvider.h"

int main(int argc, char *argv[])
{
    QCoreApplication::setAttribute(Qt::AA_EnableHighDpiScaling);

    QGuiApplication app(argc, argv);

    qDebug() << "Main thread context" << QThread::currentThreadId();

    DataProvider provider; // Communications API with hidden thread.
    DataModel model;

    // Connect signals and slots as you normally would.
    // QObject::connect defaults to Qt::AutoConnection enabling
    // cross thread signals and slots. The data model functions
    // are only called from the main thread.
    QObject::connect(&provider, &DataProviderInterface::timeChanged,
                     &model, &DataModel::setTime);

    QQmlApplicationEngine engine;
    const QUrl url(QStringLiteral("qrc:/main.qml"));
    QObject::connect(&engine, &QQmlApplicationEngine::objectCreated,
                     &app, [url](QObject *obj, const QUrl &objUrl) {
        if (!obj && url == objUrl)
            QCoreApplication::exit(-1);
    }, Qt::QueuedConnection);

    engine.rootContext()->setContextProperty("dataModel", &model);
    engine.load(url);

    return app.exec();
}
