// Copyright 2019 ICS Inc.

import QtQuick 2.12
import QtQuick.Window 2.12

Window {
    visible: true; width: 640; height: 480

    property var btnWidth: (width - 120) / 2
    property var btnHeight: (height - 120) / 2

    Rectangle {
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.margins: 50
        width: btnWidth
        height: btnHeight
        color: "lightblue"
        Text {
            anchors.centerIn: parent
            text: "Click Me"; font.pixelSize: 48
        }
        MouseArea {
            anchors.fill: parent
            onPressed: parent.color = "lime"
            onReleased: parent.color = "lightblue"
        }
    }

    Rectangle {
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.margins: 50
        width: btnWidth
        height: btnHeight
        color: "lime"
        Text {
            anchors.centerIn: parent
            text: "Hold Me"; font.pixelSize: 48
        }
        MouseArea {
            anchors.fill: parent
            onPressAndHold: parent.color = "lightblue"
            onReleased: parent.color = "lime"
        }
    }

    Rectangle {
        anchors.left: parent.left
        anchors.bottom: parent.bottom
        anchors.margins: 50
        width: btnWidth
        height: btnHeight
        color: mouseArea.containsMouse ? "yellow" : "orange"
        Text {
            anchors.centerIn: parent
            text: "Hover Me"; font.pixelSize: 48
        }
        MouseArea {
            id: mouseArea
            anchors.fill: parent
            hoverEnabled: true
        }
    }

    Rectangle {
        x: btnWidth + 70
        y: btnHeight + 70
        width: btnWidth
        height: btnHeight
        color: "yellow"
        Text {
            anchors.centerIn: parent
            text: "Drag Me"; font.pixelSize: 48
        }
        MouseArea {
            anchors.fill: parent
            drag.target: parent
            drag.axis: Drag.XAndYAxis
            onReleased: {
                parent.x = btnWidth + 70
                parent.y = btnHeight + 70
            }
        }
    }
}
