// Copyright 2019 ICS Inc.

import QtQuick 2.12
import QtQuick.Window 2.12

Window {
    visible: true; width: 640; height: 480

    Text {
        id: text
        text: "Fingers, do your thing"
        font.pointSize: 20
        anchors.centerIn: parent
    }

    MultiPointTouchArea {
        anchors.fill: parent
        touchPoints: [
            TouchPoint { id: point1 },
            TouchPoint { id: point2 },
            TouchPoint { id: point3 },
            TouchPoint { id: point4 },
            TouchPoint { id: point5 },
            TouchPoint { id: point6 },
            TouchPoint { id: point7 },
            TouchPoint { id: point8 },
            TouchPoint { id: point9 },
            TouchPoint { id: point10 }
        ]
        onTouchUpdated: {
            var str = "Count: " + touchPoints.length + "\n"
            for( var i=0; i < touchPoints.length; i++) {
                str = str + (touchPoints[i].pointId - 33554432) + ": (" + touchPoints[i].x + " , " + touchPoints[i].y + ")\n"
            }
            text.text = str
        }
    }

    Rectangle {
        width:150; height: 150
        color: "darkred"
        x: point1.x - 75
        y: point1.y - 75
        visible: point1.pressed
    }

    Rectangle {
        width:150; height: 150
        color: "red"
        x: point2.x - 75
        y: point2.y - 75
        visible: point2.pressed
    }

    Rectangle {
        width:150; height: 150
        color: "orange"
        x: point3.x - 75
        y: point3.y - 75
        visible: point3.pressed
    }

    Rectangle {
        width:150; height: 150
        color: "yellow"
        x: point4.x - 75
        y: point4.y - 75
        visible: point4.pressed
    }

    Rectangle {
        width:150; height: 150
        color: "lightgreen"
        x: point5.x - 75
        y: point5.y - 75
        visible: point5.pressed
    }

    Rectangle {
        width:150; height: 150
        color: "green"
        x: point6.x - 75
        y: point6.y - 75
        visible: point6.pressed
    }

    Rectangle {
        width:150; height: 150
        color: "lightblue"
        x: point7.x - 75
        y: point7.y - 75
        visible: point7.pressed
    }

    Rectangle {
        width:150; height: 150
        color: "blue"
        x: point8.x - 75
        y: point8.y - 75
        visible: point8.pressed
    }

    Rectangle {
        width:150; height: 150
        color: "indigo"
        x: point9.x - 75
        y: point9.y - 75
        visible: point9.pressed
    }

    Rectangle {
        width:150; height: 150
        color: "violet"
        x: point10.x - 75
        y: point10.y - 75
        visible: point10.pressed
    }
}
