import QtQuick 2.12
import QtQuick.Window 2.12

Window {
    visible: true; width: 220; height: 440
    title: qsTr("Session 4 Demo")

    Item{
        anchors.fill: parent
        Rectangle {
            id: stopLight
            x:10
            width: 200; height: 200
            radius: 180
            color: "red"
            border.width: 4
            border.color: "black"
        }

        Rectangle {
            id: goLight
            x:10; y: 220;
            width: 200; height: 200
            radius: 180
            color: "green"
            border.width: 4
            border.color: "black"
        }

        MouseArea {
            id: clickArea
            anchors.fill: parent
            acceptedButtons: Qt.LeftButton | Qt.RightButton
        }

        states: [
            State {
                when: clickArea.pressedButtons == Qt.LeftButton
                PropertyChanges { target: stopLight; color: "red" }
                PropertyChanges { target: goLight; color: "black" }
            },
            State {
                when: clickArea.pressedButtons == Qt.RightButton
                PropertyChanges { target: goLight; color: "green" }
                PropertyChanges { target: stopLight; color: "black" }
            }
        ]
    }
}
