import QtQuick 2.12
import QtQuick.Window 2.12

Window {
    visible: true; width: 220; height: 440
    title: qsTr("Session 4 Demo - Simple State")

    Item{
        id: root
        anchors.fill: parent
        state: "stop"
        Rectangle {
            id: stopLight
            x: 10;
            width: 200; height: 200
            radius: 180
            color: "red"
            border.width: 4
            border.color: "black"
        }

        Rectangle {
            id: goLight
            x: 10; y: 220;
            width: 200; height: 200
            color: "green"
            radius: 180
            border.width: 4
            border.color: "black"
        }

        MouseArea {
            anchors.fill: parent
            onClicked: parent.state == "stop" ? parent.state = "go" : parent.state = "stop"
        }

        states: [
            State {
                name: "stop"
                PropertyChanges { target: stopLight; color: "red" }
                PropertyChanges { target: goLight; color: "black" }
            },
            State {
                name: "go"
                PropertyChanges { target: goLight; color: "green" }
                PropertyChanges { target: stopLight; color: "black" }
            }
        ]
    }
}
