// Copyright 2019 ICS inc.

import QtQuick 2.12

Item {
    FontMetrics {
        id: fm
    }

    SystemPalette {
        id: palette
    }
    id: root
    property alias textColor: text.color
    property alias text : text.text
    signal clicked()
    implicitHeight: fm.height
    implicitWidth: text.width + 6

    Rectangle {
        id: rect
        anchors.fill: parent
        color: palette.button
        border.color: palette.base
        Text {
            id: text
            color: palette.text
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            anchors.centerIn: parent
        }

        MouseArea {
            id: mouseArea
            anchors.fill: parent
            onClicked: root.clicked()
            onPressed: {
                textColor = palette.highlightedText
                rect.color = palette.highlight
            }
            onReleased: {
                textColor = palette.buttonText
                rect.color = palette.button
            }
        }
    }
}
