import QtQuick 2.9
import QtQuick.Window 2.2
import QtQuick.Controls 1.4

MouseArea {
    acceptedButtons: Qt.RightButton
    signal download()
    signal cancelDownload()

    property var rowIndex

    property bool downloadFinished : false

    function popupMenu(aboveItem)
    {
       contextMenu.aboveItem = aboveItem
       contextMenu.popup()
    }
    
    Menu {
        id: contextMenu
        property bool aboveItem : false
        MenuItem {
            id: downloadAction
            text: "Download"
            visible: !contextMenu.aboveItem
            onTriggered: {
                download()
            }
        }
        
        MenuItem {
            id:cancelDownloadAction
            text: downloadFinished? "Remove Download": "Cancel Download"
            visible: contextMenu.aboveItem

            onTriggered: {

                cancelDownload()
            }

        }
    }
    
}
