import QtQuick 2.9
import QtQuick.Window 2.2
import QtQuick.Controls 1.4

Item{
    FontMetrics {
        id: fontMetrics
        font.family: progress_label.font.family
    }

    Text{
        id: progress_label
        anchors.left: parent.left
        anchors.margins: 10
        text: model.progress + " %"
        width: fontMetrics.advanceWidth("000 %")
        horizontalAlignment: Text.AlignHCenter
    }

    ProgressBar {
        anchors.right: parent.right
        anchors.left: progress_label.right
        anchors.margins: 10
        value: model.progress / 100
    }
    

}
