import QtQuick 2.9
import QtQuick.Window 2.2
import QtQuick.Controls 1.4

TableView {
    anchors.fill : parent
    property alias urlColumnTitle : urlColumn.title
    property alias progressColumTitle: progressColumn.title

    TableViewColumn {
        id: urlColumn
        role: "url"

    }

    TableViewColumn {
        id: progressColumn
        role: "progress"
        title: downloadModel.headerData(1, Qt.Horizontal, DownloadModel.ProgressRole)
        resizable: false
        width: parent.width - urlColumn.width - 3 //hack, there must be a better way

        delegate:
           CustomProgressStatus {
            anchors.fill: parent
        }
    }

    UrlDialog {
        id:urlDialog
        visible: false
        onAccepted: {
            downloadModel.appendDownload(urlText)
        }
    }

    ContextMenuMouseHandler {
        anchors.fill: parent
        onDownload: {
            urlDialog.open()
        }

        onCancelDownload: {
            downloadModel.cancelDownload(rowIndex)
        }

        onPressed: {
            rowIndex = rowAt(mouse.x, mouse.y)
            popupMenu(rowIndex !== -1)
            if(rowIndex !== -1 )
                downloadFinished = downloadModel.isFinished(rowIndex)
        }

    }
}
