import QtQuick 2.9
import QtQuick.Window 2.2
import QtQuick.Controls 1.4
import QtQuick.Dialogs 1.2

Dialog {
    id: textDialog

    title: "Choose a URL"
    standardButtons: StandardButton.Ok | StandardButton.Cancel
    property alias urlText : urlText.text


    TextField {
        id: urlText
        placeholderText: "Enter a URL . . ."
        focus: true
        anchors.left: parent.left
        anchors.right: parent.right
    }

    onVisibilityChanged: {
        if(visible)
            urlText.focus = true
    }

}
