#ifndef DOWNLOADS_H
#define DOWNLOADS_H

#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QUrl>
#include <QFile>

class Downloads : public QNetworkAccessManager
{
    Q_OBJECT
public:
    explicit Downloads(QUrl url, QObject *parent = 0);

    QUrl url() const;
    void setUrl(const QUrl &url);

    qint64 progress() const;
    void setProgress(const qint64 &progress);

    qint64 total() const;
    void setTotal(const qint64 &total);

    bool wasAborted() const;
    void setWasAborted(bool wasAborted);

    bool isFinished();

signals:
    void downloadProgress(qint64,qint64);
    void error(QNetworkReply::NetworkError);

public slots:
    void replyFinished();
    void abortDownload();

private slots:
    void handleProgress(qint64,qint64);
    void httpReadyRead();


private:
    QUrl m_url;

    qint64 m_progress;
    qint64 m_total;
    bool m_wasAborted;


    QFile * m_file;
    QNetworkReply* m_reply;

    void startRequest(const QUrl &requestedUrl);
};

#endif // DOWNLOADS_H
