#include "downloadsmodel.h"
#include <QDebug>
#include <QMetaEnum>


DownloadsModel::DownloadsModel(QObject* parent)
    :QAbstractTableModel(parent)
{

}


int DownloadsModel::rowCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent)
    return DownLoadList.count();
}

int DownloadsModel::columnCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent)
    return 2;
}

QVariant DownloadsModel::data(const QModelIndex &index, int role) const
{

    if( role == UrlRole)
    {
        return DownLoadList.at(index.row())->url();
    }
    else if ( role == ProgressRole )
    {
        if( DownLoadList.at(index.row())->wasAborted() )
        {
            return -1;
        }

        if(DownLoadList.at(index.row())->total() > 0)
            return ( DownLoadList.at(index.row())->progress() * 100
                     / DownLoadList.at(index.row())->total());
        else
            return 0;
    }

    return QVariant();
}

bool DownloadsModel::appendDownload(const QVariant &value)
{
    Downloads* currentDownload = new Downloads(value.toUrl(), this);

    emit beginInsertRows(QModelIndex(),rowCount(),rowCount());
    DownLoadList.append(currentDownload);
    emit endInsertRows();
    connect(DownLoadList.last(), SIGNAL(downloadProgress(qint64,qint64)), this, SLOT(handleProgress(qint64,qint64)));
    connect( DownLoadList.last(), SIGNAL(error(QNetworkReply::NetworkError)),this, SLOT(handleError(QNetworkReply::NetworkError)));

    QModelIndex topLeft = createIndex(0,0);

    //emit a signal to make the view reread identified data
    emit dataChanged(topLeft, topLeft);

    return true;
}

QHash<int, QByteArray> DownloadsModel::roleNames() const {
    QHash<int, QByteArray> roles;
    roles[UrlRole] = "url";
    roles[ProgressRole] = "progress";
    return roles;
}

QVariant DownloadsModel::headerData(int section, Qt::Orientation orientation, int role) const
{
    Q_UNUSED(section)
    if(orientation == Qt::Horizontal)
    {
        switch(role)
        {
        case UrlRole: return QString("URL");break;
        case ProgressRole: return QString("Progress");break;
        }
    }
    return QVariant();
}

void DownloadsModel::handleProgress(qint64 current, qint64 total)
{
    Q_UNUSED(current)
    Q_UNUSED(total)
    QObject* object = sender();
    Downloads* download= qobject_cast<Downloads*>(object);

    if(download)
    {
        int row = DownLoadList.indexOf(download);
        QModelIndex topLeft = createIndex(row,1);
        emit dataChanged(topLeft , topLeft);
    }
}

void DownloadsModel::handleError(QNetworkReply::NetworkError error)
{
    if( error == QNetworkReply::ProtocolUnknownError )
    {
        QObject* object = sender();
        Downloads* download= qobject_cast<Downloads*>(object);
        if(download)
        {
                int row = DownLoadList.indexOf(download);
                DownLoadList.at(row)->deleteLater();

                beginRemoveRows(QModelIndex(),row,row);
                    DownLoadList.removeAt(row);
                endRemoveRows();
        }


    }
}

void DownloadsModel::cancelDownload(int index)
{    
    DownLoadList.at(index)->abortDownload();

    DownLoadList.at(index)->deleteLater();

    beginRemoveRows(QModelIndex(),index,index);
        DownLoadList.removeAt(index);
        endRemoveRows();
}

bool DownloadsModel::isFinished(int row)
{
   bool result = false;

   if( row >= 0 &&  row < rowCount() )
    result = DownLoadList.at(row)->isFinished();

   return result;
}
