#ifndef DOWNLOADSMODEL_H
#define DOWNLOADSMODEL_H

#include <QAbstractTableModel>
#include "downloads.h"
#include <QList>


class DownloadsModel : public QAbstractTableModel
{
    Q_OBJECT
public:
    DownloadsModel(QObject *parent = 0);

    enum DownloadRoles {
        UrlRole = Qt::UserRole + 1,
        ProgressRole
    };

    Q_ENUM( DownloadRoles )

    // QAbstractItemModel interface
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    QHash<int, QByteArray> roleNames() const;

    Q_INVOKABLE bool appendDownload(const QVariant &value);
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;
    Q_INVOKABLE void cancelDownload(int);
    Q_INVOKABLE bool isFinished(int);

protected slots:
    void handleProgress(qint64,qint64);
    void handleError(QNetworkReply::NetworkError);


private:
    QList<Downloads*> DownLoadList;
};

#endif // DOWNLOADSMODEL_H
