#include <QGuiApplication>
#include <QQmlApplicationEngine>
#include <QQmlContext>
#include "downloadsmodel.h"

int main(int argc, char *argv[])
{
#if defined(Q_OS_WIN)
    QCoreApplication::setAttribute(Qt::AA_EnableHighDpiScaling);
#endif

    QGuiApplication app(argc, argv);

    qmlRegisterType<DownloadsModel>("training.ics.objects",1,0,"DownloadModel");

    DownloadsModel _model;
    QQmlApplicationEngine engine;
    engine.rootContext()->setContextProperty("downloadModel",&_model);
    engine.load(QUrl(QStringLiteral("qrc:/main.qml")));
    if (engine.rootObjects().isEmpty())
        return -1;

    return app.exec();
}
