#include "downloadmodel.h"

#include "downloads.h"
#include <QtGlobal>

DownloadModel::DownloadModel(QObject *parent)
    : QAbstractTableModel(parent)
{
}

QVariant DownloadModel::headerData(int section, Qt::Orientation orientation,
                                   int role) const
{
    // FIXME: Implement me!
    if( orientation == Qt::Horizontal  && role == Qt::DisplayRole)
    {
        if (section == 0 )
            return QString(tr("URL"));
        else if (section == 1)
            return QString(tr("Progress"));
    }

    return QVariant();
}

int DownloadModel::rowCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent);
    return this->downloads.size();
}

int DownloadModel::columnCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent);
    return 2;
}

QVariant DownloadModel::data(const QModelIndex &index, int role) const
{

    if (!index.isValid())
        return QVariant();


    if (index.row() >= this->downloads.size() || index.row() < 0 || index.column() > 1)
        return QVariant();


    if (role == Qt::DisplayRole)
    {
        Downloads*  download = nullptr;
        if( index.row() < downloads.size() )
             download = this->downloads.at(index.row());


        if (index.column() == 0)            
        {
            if( download )
                return download->url();
        }
        else if (index.column() == 1)
        {
            if( download && download->total() > 0)
            {
                double percent = (download->progress() * 1.0)
                        /(download->total()*1.0)*100.0;
                if(qIsNaN(percent) || percent < 0.0)
                    percent = 0.0;


                int percentInt = percent;
                return percentInt;
            }
            else return 0;
        }
    }

    return QVariant();

}



bool DownloadModel::insertRows(int row, int count, const QModelIndex &parent)
{

    beginInsertRows(parent, row, row + count - 1);


    for (int row = 0; row < count; ++row)
    {
        // insert dummy row

        this->downloads.insert(row, Q_NULLPTR);
    }


    endInsertRows();

    return true;

}

bool DownloadModel::appendDownload(const QVariant & value)
{
    Downloads * download = new Downloads(value.toString());

    emit beginInsertRows(QModelIndex(), this->rowCount(), this->rowCount());
    this->downloads.append(download);
    emit endInsertRows();

    connect(download, &Downloads::downloadProgress,
            this, &DownloadModel::onUpdateProgress);

    return true;
}

void DownloadModel::onUpdateProgress(qint64, qint64)
{
    Downloads* download = qobject_cast<Downloads*>(sender());
    if( download != Q_NULLPTR )
    {
        int row = this->downloads.indexOf(download);
        QModelIndex index = this->index(row,1);
        emit dataChanged(index, index); // refresh download column
    }
}
