#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "downloads.h"
#include "downloadmodel.h"

#include <QInputDialog>
#include <QUrl>

#include "progressbardelegate.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    ProgressBarDelegate* delegate = new ProgressBarDelegate(this);
    model = new DownloadModel(this);

    ui->tableView->setModel(model);
    ui->tableView->setItemDelegateForColumn(1, delegate);

    ui->tableView->addAction(ui->actionDownload);

    connect(ui->actionDownload, &QAction::triggered, this,
            &MainWindow::onDownload);


}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::onDownload()
{

    bool ok;
    QUrl downloadUrl = QInputDialog::getText(
                this, tr("Choose a Url"), tr("Download Url:"),
                QLineEdit::Normal, "", &ok);


    if( ok && !downloadUrl.isEmpty())
    {        
        this->model->appendDownload(downloadUrl);
    }
}
