#ifndef INVENTORYCBORREADER_H
#define INVENTORYCBORREADER_H

#include <QCborStreamReader>
#include "inventoryitem.h"

class InventoryCborReader
{
public:
    InventoryCborReader();

    bool readCborFile(QString filePath);

    QList<InventoryItem> getItemList() { return m_itemList; }

private:
    QString m_currentKey;
    InventoryItem m_currentItem;
    QList<InventoryItem> m_itemList;

    bool readCborData(QCborStreamReader* reader);
    void assignStringValue(QString value);
    void assignDoubleValue(double value);
    void assignUnsignedIntegerValue(quint64 value);
    void assignNegativeIntegerValue(qint64 value);
    void assignBooleanValue(bool value);
    void assignUuid(QUuid value);
};

#endif // INVENTORYCBORREADER_H
