#include "inventorycborwriter.h"

#include <QFile>

InventoryCborWriter::InventoryCborWriter()
{
}

bool InventoryCborWriter::writeCborFile(QString filePath, QList<InventoryItem> items)
{
    QFile file(filePath);
    bool ret = file.open(QIODevice::WriteOnly);
    if (!ret)
        return false;

    // New QCborStreamWriter created from specified file
    QCborStreamWriter writer(&file);

    // Start of array containing all inventory items
    writer.startArray();

    // Each inventory item is a map
    for (InventoryItem item: items)
    {
        writer.startMap();

        // Name
        writer.append("Name");
        writer.append(item.getName());

        // UUID -- append a tag before the byte array containing
        // the UUID data
        writer.append("ID");
        writer.append(QCborKnownTags::Uuid);
        writer.append(item.getID().toByteArray());

        // Price
        writer.append("Price");
        writer.append(item.getPrice());

        // Quantity
        writer.append("Quantity");
        writer.append(item.getQuantity());

        // Used -- boolean is a CBOR simple type
        writer.append("Used");
        if (item.getUsed())
            writer.append(QCborSimpleType::True);
        else
            writer.append(QCborSimpleType::False);

        writer.endMap();
    }

    // End of array containing all inventory items
    writer.endArray();

    file.close();

    return true;
}
