#include "inventorylistmodel.h"

InventoryListModel::InventoryListModel(QObject *parent)
    : QAbstractListModel(parent)
{
    m_writer = new InventoryCborWriter();
    m_reader = new InventoryCborReader();
}

int InventoryListModel::rowCount(const QModelIndex &) const
{
    return m_items.count();
}

QVariant InventoryListModel::data(const QModelIndex &index, int role) const
{
    if (role != Qt::DisplayRole)
        return QVariant();

    if (role == Qt::DisplayRole)
        return m_items.at(index.row()).getName();

    return QVariant();
}

InventoryItem InventoryListModel::getItem(int i)
{
    if (i >= m_items.count() || i < 0)
        return InventoryItem();

    return m_items.at(i);
}

void InventoryListModel::addItem(InventoryItem newItem)
{
    beginInsertRows(QModelIndex(), 0, 0);
    m_items.push_front(newItem);
    endInsertRows();
}

void InventoryListModel::updateItem(int row, InventoryItem newItem)
{
    if (row >= m_items.count() || row < 0)
        return;

    m_items.replace(row, newItem);
}

void InventoryListModel::deleteItem(int row)
{
    beginRemoveRows(QModelIndex(), row, row);
    m_items.removeAt(row);
    endRemoveRows();
}

// Write out a file containing CBOR data based on the list of inventory items
bool InventoryListModel::writeCborFile(QString fileName)
{
    return m_writer->writeCborFile(fileName, m_items);
}

// Read a file containing CBOR data and construct a list of inventory items from it
bool InventoryListModel::readCborFile(QString fileName)
{
    bool ret = m_reader->readCborFile(fileName);
    if (ret)
    {
        QList<InventoryItem> newItems = m_reader->getItemList();
        if (newItems.count() > 0)
        {
            beginResetModel();
            m_items.clear();
            endResetModel();

            for (InventoryItem item: newItems)
            {
                addItem(item);
            }
        }
        return true;
    }
    else
    {
        return false;
    }
}
