#ifndef INVENTORYLISTMODEL_H
#define INVENTORYLISTMODEL_H

#include <QAbstractListModel>

#include "inventoryitem.h"
#include "inventorycborwriter.h"
#include "inventorycborreader.h"

class InventoryListModel : public QAbstractListModel
{
    Q_OBJECT
public:
    explicit InventoryListModel(QObject *parent = nullptr);

    int rowCount(const QModelIndex & = QModelIndex()) const override;
    QVariant data(const QModelIndex &, int) const override;

    InventoryItem getItem(int i);
    void addItem(InventoryItem newItem);
    void updateItem(int row, InventoryItem newItem);
    void deleteItem(int row);

    QList<InventoryItem> getItems() { return m_items; }

    bool writeCborFile(QString fileName);
    bool readCborFile(QString fileName);

signals:

public slots:

private:
    QList<InventoryItem> m_items;
    InventoryCborWriter* m_writer;
    InventoryCborReader* m_reader;
};

#endif // INVENTORYLISTMODEL_H
