#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QItemSelection>

#include "inventorylistmodel.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

private slots:
    void onAddClicked();
    void onDeleteClicked();
    void onApplyClicked();
    void onImport();
    void onExport();
    void onItemEdited(const QString &text);
    void onCheckboxClicked();
    void selectionChangedSlot(const QItemSelection &selected, const QItemSelection &deselected);

private:
    Ui::MainWindow *ui;

    InventoryListModel* m_model;

    void enableEntryUI(bool enabled);
};

#endif // MAINWINDOW_H
