#include <QGuiApplication>
#include <QQmlApplicationEngine>
#include <QQmlContext>

#include <QRandomGenerator>
#include <QDateTime>
#include <QStandardItemModel>

#include "filterproxywrapper.h"


void populateModel(QStandardItemModel & model, QRandomGenerator &rand);
QString dataString(QRandomGenerator &rand);

int main(int argc, char *argv[])
{
    QCoreApplication::setAttribute(Qt::AA_EnableHighDpiScaling);

    QGuiApplication app(argc, argv);

    QQmlApplicationEngine engine;
    QQmlContext *context = engine.rootContext();

    QRandomGenerator rdm(static_cast<quint32>(QTime::currentTime().second()));

    QStandardItemModel listModel;
    populateModel(listModel, rdm);

    FilterProxyWrapper proxyWrapper;
    proxyWrapper.setSourceModel(&listModel);

    context->setContextProperty(QStringLiteral("proxyWrapper"), &proxyWrapper);

    engine.load(QUrl(QStringLiteral("qrc:/main.qml")));
    if (engine.rootObjects().isEmpty())
        return -1;

    return app.exec();
}

QString dataString(QRandomGenerator &rand)
{
    int yearNum = rand.bounded(1990,2020);
    int monthNum = rand.bounded(1,12);
    int dayNum = rand.bounded(1,31);
    if (dayNum > 28 && monthNum == 2) {
        dayNum %= 28;
    } else if (dayNum > 30 && (monthNum == 4 || monthNum == 6 || monthNum == 9 || monthNum == 11)) {
        dayNum %= 30;
    }
    QString value = QString::number(rand.bounded(25.0));
    int unitType = rand.bounded(1,9);

    QDate date(yearNum, monthNum, dayNum);
    QString year = date.toString("yyyy");
    QString month = date.toString("MMM");
    QString day = date.toString("dd");
    QString unit;
    switch(unitType) {
    case 1:
        unit = QString("in");
        break;
    case 2:
        unit = QString("cm");
        break;
    case 3:
        unit = QString("lb.");
        break;
    case 4:
        unit = QString("kg");
        break;
    case 5:
        unit = QString("deg F");
        break;
    case 6:
        unit = QString("deg C");
        break;
    case 7:
        unit = QString("gal");
        break;
    case 8:
        unit = QString("liters");
        break;
    default:
        unit = QString("units");
        break;
    }
    QString data = QString("%1-%2-%3: %4 %5").arg(year,month,day,value,unit);
    return data;
}

void populateModel(QStandardItemModel & model, QRandomGenerator &rand)
{
    QStandardItem *parentItem = model.invisibleRootItem();
    for (int i=0; i<50; ++i) {
        QStandardItem* item = new QStandardItem();
        item->setData(dataString(rand), Qt::DisplayRole);
        parentItem->setChild(i, item);
    }

    parentItem->sortChildren(0);
}
