import QtQuick 2.12
import QtQuick.Window 2.12
import QtQuick.Controls 2.5

Window {
    visible: true
    width: 1280
    height: 1024
    title: qsTr("Regular Expression Demo")
    color: "lightgray"

    ComboBox {
        id: selectionBox
        x: 50
        y: 50
        width: 500
        height: 32

        textRole: "key"

        model: ListModel {
            id: model
            ListElement { key: ""; value: "" }
            ListElement { key: "Year-Month-Day pattern, before 10th of month"; value: "^\\d\\d\\d\\d.\\w\\w\\w.0\\d" }
            ListElement { key: "Year-Month-Day pattern, between 10th and 19th of month"; value: "^\\d\\d\\d\\d.\\w\\w\\w.1\\d" }
            ListElement { key: "Year-Month pattern, year before 2000"; value: "^19\\d\\d.\\w\\w\\w" }
            ListElement { key: "Year-Month pattern, year 2000 to 2009"; value: "^200\\d.\\w\\w\\w" }
            ListElement { key: "Year-Month pattern, year 2010 to 2019"; value: "^201\\d.\\w\\w\\w" }
            ListElement { key: "Year-Month pattern, month beginning with M"; value: "^\\d\\d\\d\\d.M\\w\\w" }
            ListElement { key: "Year-Month pattern, month beginning with J"; value: "^\\d\\d\\d\\d.J\\w\\w" }
            ListElement { key: "Value-[in|cm] pattern"; value : "\\d+\\.\\d+\\ in|cm"}
            ListElement { key: "Value-[lb|kg] pattern"; value : "\\d+\\.\\d+\\ lb|kg"}
            ListElement { key: "Value-[deg F|deg C] pattern"; value : "\\d+\\.\\d+\\ deg F|deg C"}
            ListElement { key: "Value-[gal|liter] pattern"; value : "\\d+\\.\\d+\\ gal|lit"}
        }
        onActivated: {
            filterValue.text = (currentIndex > 0) ? "Regular Expression: \"" + model.get(currentIndex).value + "\"" : ""
            proxyWrapper.setFilterRegularExpression(model.get(currentIndex).value)
        }
    }
    Text {
        id: filterValue
        anchors.left: selectionBox.right
        anchors.leftMargin: 20
        anchors.verticalCenter: selectionBox.verticalCenter

        font.pixelSize: 18
        text:""
    }

    ListView {
        id: mainListView
        anchors.top: selectionBox.bottom
        anchors.topMargin: 50
        anchors.left: parent.left
        anchors.leftMargin: 100
        anchors.right: parent.right
        anchors.rightMargin: 100
        height: 800

        model: proxyWrapper

        delegate: Rectangle {
            border.color: "black"
            color: "white"
            width: mainListView.width
            height: 36
            Text {
                anchors.centerIn: parent
                font.pixelSize: 18
                text: model.display
            }
        }
    }
}
